<?php
// LINHA 2: Blindagem contra estouro de memória (Fatal error: Allowed memory size)
@ini_set('memory_limit', '512M'); 
@gc_enable(); 

session_start();

/**
 * BLINDAGEM DE CONEXÃO E SESSÃO
 * Este bloco mantém a lógica original, mas adiciona travas de segurança
 * contra falhas de DNS, Timeouts e respostas inválidas da API.
 */

// 1. Verificación de sesión activa (Original intacto)
if (!isset($_SESSION["username"]) || !isset($_SESSION["password"]) || !isset($_SESSION["server_url"])) {
    header("Location: ./login.php");
    exit;
}

// 2. Cargar y Limpiar datos de sesión (Previene erros de caracteres especiais)
$get_dns = rtrim($_SESSION["server_url"], '/'); // Remove barras extras no final
$username = urlencode($_SESSION["username"]);
$password = urlencode($_SESSION["password"]);

// 3. Autenticación via cURL (Mais seguro e rápido que file_get_contents)
$authUrl = "{$get_dns}/player_api.php?username={$username}&password={$password}";
$userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $authUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Blindagem: Não deixa a página travar se o servidor cair
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_ENCODING, ""); // Habilita compressão para reduzir uso de RAM no tráfego

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// 4. Decodificação e Validação Blindada
$api = json_decode($response, true);

// LIBERAÇÃO DE MEMÓRIA: Destrói a string bruta logo após a decodificação
unset($response); 

/**
 * Lógica de Verificación Reforzada
 */
$is_authenticated = (
    $httpCode === 200 && 
    is_array($api) && 
    isset($api['user_info']['auth']) && 
    $api['user_info']['auth'] == 1 && 
    isset($api['user_info']['status']) && 
    $api['user_info']['status'] === "Active"
);

if (!$is_authenticated) {
    session_unset();
    session_destroy();
    header("Location: ./login.php?error=auth_failed");
    exit;
}

// Limpeza final de referências circulares
gc_collect_cycles();

// O código continua original daqui para baixo
echo "\n";
?>